# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # Round 1: Cooperate
    
    current_round = len(my_history) + 1
    
    if current_round == 10:
        return "D"  # Final round: Always defect
    
    if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        return "D"  # Permanent defection after two consecutive defections
    
    if opp_history[-1] == "D":
        return "D"  # Tit-for-Tat: Defect if opponent defected last
    
    # Tit-for-Tat with 10% randomness: Cooperate with 90%, Defect with 10%
    if random.random() < 0.1:
        return "D"
    else:
        return "C"